-- Veritabanı şeması
CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(50) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  department VARCHAR(100) NOT NULL,
  role ENUM('department','admin') NOT NULL DEFAULT 'department',
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE events (
  id INT AUTO_INCREMENT PRIMARY KEY,
  created_by INT NOT NULL,
  department VARCHAR(100) NOT NULL,
  title VARCHAR(200) NOT NULL,
  event_type ENUM('Toplanti','Acilis','Konser','Seminer','Saha Calismasi','Diger') NOT NULL DEFAULT 'Diger',
  location VARCHAR(200) NOT NULL,
  start_at DATETIME NOT NULL,
  end_at DATETIME NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (created_by) REFERENCES users(id)
);

CREATE INDEX idx_events_start ON events(start_at);
CREATE INDEX idx_events_dept  ON events(department);
