<?php
declare(strict_types=1);
require_once __DIR__ . '/auth.php';

ensure_session();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim((string)($_POST['username'] ?? ''));
  $password = (string)($_POST['password'] ?? '');

  $stmt = db()->prepare("SELECT id, password_hash FROM users WHERE username=? AND is_active=1");
  $stmt->execute([$username]);
  $u = $stmt->fetch();

  if ($u && password_verify($password, $u['password_hash'])) {
    $_SESSION['uid'] = (int)$u['id'];
    header('Location: dashboard.php');
    exit;
  } else {
    $error = 'Kullanıcı adı veya şifre hatalı.';
  }
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <title>Giriş • <?= htmlspecialchars(APP_NAME) ?></title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
  <div class="header">
    <h2 style="margin:0;">Giriş</h2>
    <a href="public.php">Takvime dön</a>
  </div>

  <div class="card">
    <?php if ($error): ?><div style="margin-bottom:10px;color:#b91c1c;"><?= htmlspecialchars($error) ?></div><?php endif; ?>
    <form method="post">
      <div class="row">
        <input name="username" placeholder="Kullanıcı adı" required>
        <input name="password" type="password" placeholder="Şifre" required>
      </div>
      <div style="margin-top:10px;">
        <button type="submit">Giriş Yap</button>
      </div>
    </form>
  </div>
</body>
</html>
