<?php
declare(strict_types=1);
require_once __DIR__ . '/auth.php';
require_login();

$u = current_user();
if (!$u) { header('Location: logout.php'); exit; }

$ym = $_GET['ym'] ?? date('Y-m');
if (!preg_match('/^\d{4}-\d{2}$/', $ym)) $ym = date('Y-m');
$start = $ym . '-01 00:00:00';
$end = date('Y-m-01 00:00:00', strtotime($start . ' +1 month'));

$params = [$start, $end];
$whereUser = '';
if ($u['role'] !== 'admin') {
  $whereUser = " AND created_by = ? ";
  $params[] = $u['id'];
}

$stmt = db()->prepare("
  SELECT id, department, title, event_type, location, start_at, end_at, created_by
  FROM events
  WHERE start_at >= ? AND start_at < ? $whereUser
  ORDER BY start_at ASC
");
$stmt->execute($params);
$events = $stmt->fetchAll();

$prev = date('Y-m', strtotime($start . ' -1 month'));
$next = date('Y-m', strtotime($start . ' +1 month'));
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <title>Panel • <?= htmlspecialchars(APP_NAME) ?></title>
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>
  <div class="header">
    <div>
      <h2 style="margin:0;">Panel</h2>
      <small><?= htmlspecialchars($u['department']) ?> • <?= htmlspecialchars($u['username']) ?> • <?= htmlspecialchars($u['role']) ?></small>
    </div>
    <div class="row">
      <a class="card" style="padding:8px 12px;display:inline-block" href="public.php">Şifresiz Takvim</a>
      <a class="card" style="padding:8px 12px;display:inline-block" href="logout.php">Çıkış</a>
    </div>
  </div>

  <div class="card">
    <h3 style="margin-top:0;">Etkinlik Ekle</h3>
    <form method="post" action="event_save.php">
      <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
      <div class="row">
        <input name="title" placeholder="Etkinlik adı" required>
        <select name="event_type">
          <option>Toplanti</option>
          <option>Acilis</option>
          <option>Konser</option>
          <option>Seminer</option>
          <option>Saha Calismasi</option>
          <option selected>Diger</option>
        </select>
        <input name="location" placeholder="Yer" required>
      </div>
      <div class="row" style="margin-top:10px;">
        <input name="start_at" type="datetime-local" required>
        <input name="end_at" type="datetime-local" required>
        <button type="submit">Kaydet</button>
      </div>
      <small>Not: Müdürlük otomatik alınır. (Kullanıcı hesabından)</small>
    </form>
  </div>

  <div class="card">
    <div class="row" style="align-items:center;justify-content:space-between">
      <div>
        <a href="?ym=<?= $prev ?>">&larr; Önceki</a>
        <span style="margin:0 10px;font-weight:700;"><?= htmlspecialchars($ym) ?></span>
        <a href="?ym=<?= $next ?>">Sonraki &rarr;</a>
      </div>
      <form method="get">
        <input name="ym" value="<?= htmlspecialchars($ym) ?>" placeholder="YYYY-AA">
        <button type="submit">Git</button>
      </form>
    </div>

    <table style="margin-top:12px;">
      <thead>
        <tr>
          <th>Tarih/Saat</th>
          <th>Müdürlük</th>
          <th>Tür</th>
          <th>Etkinlik</th>
          <th>Yer</th>
          <th>İşlem</th>
        </tr>
      </thead>
      <tbody>
      <?php if (!$events): ?>
        <tr><td colspan="6"><small>Kayıt yok.</small></td></tr>
      <?php else: foreach ($events as $e): ?>
        <tr>
          <td><?= htmlspecialchars(date('d.m.Y H:i', strtotime($e['start_at']))) ?>
            <small>– <?= htmlspecialchars(date('H:i', strtotime($e['end_at']))) ?></small>
          </td>
          <td><?= htmlspecialchars($e['department']) ?></td>
          <td><span class="badge"><?= htmlspecialchars($e['event_type']) ?></span></td>
          <td><?= htmlspecialchars($e['title']) ?></td>
          <td><?= htmlspecialchars($e['location']) ?></td>
          <td>
            <form method="post" action="event_delete.php" onsubmit="return confirm('Silinsin mi?')">
              <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
              <input type="hidden" name="id" value="<?= (int)$e['id'] ?>">
              <button type="submit">Sil</button>
            </form>
          </td>
        </tr>
      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
